

;*****************************************************************************************
;	Mega 128 Scope Controller Program
;	(c) Martin Cibulski
;*****************************************************************************************

;Word offsets in a menu entry's jump table

.EQU	MNU_CALL_SHOW1	= 0
.EQU	MNU_CALL_SHOW2	= 1
.EQU	MNU_CALL_MAX_IND	= 2
.EQU	MNU_CALL_STARTIND	= 3
.EQU	MNU_CALL_FASTSTEP	= 4
.EQU	MNU_CALL_EXEC	= 5

;Byte offsets in a menu entry
;
.EQU	MNU_TEXT	=  0		
.EQU	MNU_PARENT_PTR	=  8
.EQU	MNU_ADRESS	= 10
.EQU	MNU_ENTRY_SIZE	= 12

.DSEG
men_message:	.byte	8

.CSEG


;*****************************************************************************************
;Menu Table

;Entry Name (label)	Display Text	Parent Entry	Function Adress
;-----------------------------------------------------------------------------------------
men_root:	.db	"MENUE   "
	.dw		0	,0
;-----------------------------------------------------------------------------------------
men_obj:	.db	"OBJ DB  "
	.dw		men_root	,0
men_object:	.db	"OBJECT  "
	.dw		men_root	,0
men_radec:	.db	"RA/DEC  "
	.dw		men_root	,fun_radec
men_system:	.db	"SYSTEM  "
	.dw		men_root	,0
;-----------------------------------------------------------------------------------------
men_obj_dir:	.db	"OBJ_DIR "
	.dw		men_obj	,fun_obj_dir
men_obj_db:	.db	"OBJ_DB  "
	.dw		men_obj_dir	,fun_obj_db
	.db	"GOTO    "
	.dw		men_obj_db	,fun_obj_goto
	.db	"ALIGN 1 "
	.dw		men_obj_db	,fun_obj_align1
	.db	"ALIGN 2 "
	.dw		men_obj_db	,fun_obj_align2
;-----------------------------------------------------------------------------------------
men_stars:	.db	"STARS   "
	.dw		men_object	,0
men_messier:	.db	"MESSIER "
	.dw		men_object	,0
men_ngc:	.db	"NGC     "
	.dw		men_object	,0
men_radec_ra:	.db	"SET RA  "
	.dw		men_radec	,fun_radec_ra
men_radec_dec:	.db	"SET DEC "
	.dw		men_radec	,fun_radec_dec
men_sys_profiles:	.db	"PROFILES"
	.dw		men_system	,0
men_sys_reset:	.db	"RESET   "
	.dw		men_system	,fun_reset
;-----------------------------------------------------------------------------------------
men_stars_db:	.db	"********"
	.dw		men_stars	,fun_stars
	.db	"GOTO    "
	.dw		men_stars_db	,fun_stars_goto
	.db	"ALIGN 1 "
	.dw		men_stars_db	,fun_stars_align1
	.db	"ALIGN 2 "
	.dw		men_stars_db	,fun_stars_align2
men_messier_db:	.db	">MESSIER"
	.dw		men_messier	,fun_messier
	.db	"GOTO    "
	.dw		men_messier_db	,fun_messier_goto
men_ngc_db:	.db	">NGC    "
	.dw		men_ngc	,fun_ngc
	.db	"GOTO    "
	.dw		men_ngc_db	,fun_ngc_goto
men_radec_setra:	.db	"SET RA  "
	.dw		men_radec_ra	,fun_radec_setra
men_radec_setdec:	.db	"SET DEC "
	.dw		men_radec_dec	,fun_radec_setdec
men_sys_prof_db:	.db	"********"
	.dw		men_sys_profiles	,fun_profiles
	.db	"ACTIVATE"
	.dw		men_sys_prof_db	,fun_profile_act
	.db	"DEFAULT "
	.dw		men_sys_prof_db	,fun_prof_makedef
;-----------------------------------------------------------------------------------------
men_end:	.db	"# STOP #"
	.dw		0xFFFF	,0x0000


;*****************************************************************************************
;Menu function RESET

fun_reset:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	jmp	0x0000			;MNU_CALL_EXEC

;*****************************************************************************************

fun_obj_dir:
	rjmp	fun_obj_dir_show1			;MNU_CALL_SHOW1
	rjmp	fun_obj_dir_show2			;MNU_CALL_SHOW2
	rjmp	fun_obj_dir_max_index		;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_obj_dir_exec			;MNU_CALL_EXEC

fun_obj_dir_show1:
	lds	r16	,mnu_par_index
	ldi	xl	,low(men_message)
	ldi	xh	,high(men_message)
	call	obj_dir_get_name
	call	lcd_print_x1
	set
	ret

fun_obj_dir_show2:
	lds	r16	,mnu_chi_index
	ldi	xl	,low(men_message)
	ldi	xh	,high(men_message)
	call	obj_dir_get_name
	call	lcd_print_x2
	set
	ret

fun_obj_dir_max_index:
	lds	r16	,obj_used_slots
	dec	r16
	clr	r17
	clr	r18
	set
	ret

fun_obj_dir_exec:
	lds	r16	,mnu_chi_index
	call	obj_db_open
	clt
	ret


;*****************************************************************************************

fun_obj_db:
	rjmp	fun_obj_db_show1			;MNU_CALL_SHOW1
	rjmp	fun_obj_db_show2			;MNU_CALL_SHOW2
	rjmp	fun_obj_db_max_index		;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	rjmp	fun_obj_db_faststep		;MNU_CALL_FASTSTEP
	ret				;MNU_CALL_EXEC

fun_obj_db_show1:
	ldi	xl	,low(obj_ds_name)
	ldi	xh	,high(obj_ds_name)
	call	lcd_print_x2
	set
	ret

fun_obj_db_show2:
	lds	r16	,mnu_par_index
	call	obj_db_open
	lds	r16	,mnu_chi_index
	lds	r17	,mnu_chi_index+1
	call	obj_db_read_dataset
	ldi	xl	,low(obj_ds_name)
	ldi	xh	,high(obj_ds_name)
	call	lcd_print_x2
	set
	ret

fun_obj_db_max_index:
	lds	r16	,obj_db_datasets		;no of datasets in current db - 1
	lds	r17	,obj_db_datasets+1	;= no of last dataset
	clr	r0
	sec
	sbc	r16	,r0
	sbc	r17	,r0
	clr	r18			;no wraparound allowed
	set
	ret

fun_obj_db_faststep:
	lds	r16	,obj_db_datasets
	lds	r17	,obj_db_datasets+1
	lsr	r17
	ror	r16
	lsr	r17
	ror	r16
	lsr	r17
	ror	r16
	lsr	r17
	ror	r16
	lsr	r17
	ror	r16
	lsr	r17
	ror	r16
	subi	r16	,low(-1)
	sbci	r17	,high(-1)
	set
	ret



;*****************************************************************************************

fun_obj_align1:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_obj_align1_exec		;MNU_CALL_EXEC

fun_obj_align1_exec:
	in	r16	,SREG
	cli
	lds	r0	,mot_a_pos
	lds	r1	,mot_a_pos+1
	lds	r2	,mot_a_pos+2
	lds	r3	,mot_a_pos+3
	lds	r4	,mot_b_pos
	lds	r5	,mot_b_pos+1
	lds	r6	,mot_b_pos+2
	lds	r7	,mot_b_pos+3
	lds	r8	,clock
	lds	r9	,clock+1
	lds	r10	,clock+2
	lds	r11	,clock+3
	out	SREG	,r16

	sts	alg_az_steps1	,r0
	sts	alg_az_steps1+1	,r1
	sts	alg_az_steps1+2	,r2
	sts	alg_az_steps1+3	,r3
	sts	alg_alt_steps1	,r4
	sts	alg_alt_steps1+1	,r5
	sts	alg_alt_steps1+2	,r6
	sts	alg_alt_steps1+3	,r7
	sts	alg_time1	,r8
	sts	alg_time1+1	,r9
	sts	alg_time1+2	,r10
	sts	alg_time1+3	,r11

	lds	r0	,obj_ds_int_ra		;little endian
	lds	r1	,obj_ds_int_ra+1
	sts	alg_rectint1	,r1
	sts	alg_rectint1+1	,r0		;big endian

	lds	r0	,obj_ds_int_dec
	lds	r1	,obj_ds_int_dec+1
	sts	alg_declint1	,r1
	sts	alg_declint1+1	,r0

	ldi	r16	,ALG_POS_NEW
	sts	alg_newpos1	,r16

	ldi	r16	,1<<TGO_ST_NONE
	sts	tgo_status	,r16

	call	mnu_out
	set
	ret

;*****************************************************************************************

fun_obj_align2:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_obj_align2_exec		;MNU_CALL_EXEC

fun_obj_align2_exec:
	in	r16	,SREG
	cli
	lds	r0	,mot_a_pos
	lds	r1	,mot_a_pos+1
	lds	r2	,mot_a_pos+2
	lds	r3	,mot_a_pos+3
	lds	r4	,mot_b_pos
	lds	r5	,mot_b_pos+1
	lds	r6	,mot_b_pos+2
	lds	r7	,mot_b_pos+3
	lds	r8	,clock
	lds	r9	,clock+1
	lds	r10	,clock+2
	lds	r11	,clock+3
	out	SREG	,r16

	sts	alg_az_steps2	,r0
	sts	alg_az_steps2+1	,r1
	sts	alg_az_steps2+2	,r2
	sts	alg_az_steps2+3	,r3
	sts	alg_alt_steps2	,r4
	sts	alg_alt_steps2+1	,r5
	sts	alg_alt_steps2+2	,r6
	sts	alg_alt_steps2+3	,r7
	sts	alg_time2	,r8
	sts	alg_time2+1	,r9
	sts	alg_time2+2	,r10
	sts	alg_time2+3	,r11

	lds	r0	,obj_ds_int_ra		;little endian
	lds	r1	,obj_ds_int_ra+1
	sts	alg_rectint2	,r1
	sts	alg_rectint2+1	,r0		;big endian

	lds	r0	,obj_ds_int_dec
	lds	r1	,obj_ds_int_dec+1
	sts	alg_declint2	,r1
	sts	alg_declint2+1	,r0

	ldi	r16	,ALG_POS_NEW
	sts	alg_newpos2	,r16

	ldi	r16	,TGO_ST_NONE
	sts	tgo_status	,r16

	call	mnu_out
	set
	ret

;*****************************************************************************************

fun_obj_goto:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_obj_goto_exec		;MNU_CALL_EXEC

fun_obj_goto_exec:
	lds	r0	,obj_ds_int_ra
	lds	r1	,obj_ds_int_ra+1
	lds	r2	,obj_ds_int_dec
	lds	r3	,obj_ds_int_dec+1

	sts	tgo_rectint	,r1
	sts	tgo_rectint+1	,r0
	sts	tgo_declint	,r3
	sts	tgo_declint+1	,r2

	ldi	r16	,TGO_ST_NEW_TARGET
	sts	tgo_status	,r16

	call	mnu_out
	set
	ret

;****************************************************************************************

.EQU	MNU_STAR_SIZE	= 12

fun_stars_msg:
.db "And Alp ",0x79,0x01,0xE8,0x28
.db "And Bet ",0x41,0x0C,0x17,0x32
.db "Aql Alp ",0x51,0xD1,0x78,0x0C
.db "Ari Alp ",0x5A,0x16,0xFE,0x20
.db "Aur Alp ",0xAB,0x37,0xAF,0x40
.db "Aur Bet ",0x32,0x3F,0x35,0x3F
.db "Boo Alp ",0x68,0x96,0xF9,0x1A
.db "Car Alp ",0x7D,0x43,0xE6,0xB5
.db "Car Bet ",0x3E,0x61,0xF6,0x9D
.db "Car Eps ",0x55,0x58,0x51,0xAC
.db "Cen Alp1",0x9D,0x9A,0x74,0xAA
.db "Cen Alp2",0x9E,0x9A,0x74,0xAA
.db "Cen Bet ",0x54,0x94,0x1A,0xAB
.db "Cen Gam ",0xDC,0x85,0x27,0xBB
.db "Cen The ",0xD4,0x94,0xDB,0xCC
.db "Cet Bet ",0xA9,0x07,0xB5,0xE6
.db "CMa Alp ",0x37,0x47,0x7F,0xE8
.db "CMa Bet ",0x45,0x43,0xC0,0xE6
.db "CMa Del ",0x4D,0x4B,0xE3,0xDA
.db "CMa Eps ",0x96,0x49,0x42,0xD7
.db "CMi Alp ",0xBC,0x50,0x59,0x07
.db "Cru Alp1",0x3C,0x83,0x45,0xA7
.db "Cru Alp2",0x3D,0x83,0x45,0xA7
.db "Cru Bet ",0xF3,0x86,0x11,0xAC
.db "Cru Gam ",0x0A,0x84,0xB0,0xAF
.db "Cyg Alp ",0x38,0xDA,0xAC,0x3F
.db "Cyg Gam ",0xD8,0xD6,0x9C,0x38
.db "Eri Alp ",0x2D,0x11,0x83,0xAF
.db "Gem Alp ",0xE9,0x4F,0xD7,0x2C
.db "Gem Bet ",0xCB,0x51,0x69,0x27
.db "Gem Gam ",0xE9,0x45,0x0F,0x17
.db "Gru Alp ",0x7A,0xE9,0xF6,0xBD
.db "Gru Bet ",0x88,0xEF,0x12,0xBE
.db "Hya Alp ",0xC5,0x63,0xD3,0xF3
.db "Leo Alp ",0xF0,0x6A,0xD4,0x10
.db "Leo Bet ",0xA3,0x7C,0x7D,0x14
.db "Lyr Alp ",0x56,0xC4,0x8A,0x36
.db "Oph Alp ",0x70,0xB9,0xA9,0x11
.db "Ori Alp ",0x6E,0x3E,0x6A,0x0A
.db "Ori Bet ",0x4A,0x37,0x78,0xF4
.db "Ori Eps ",0x19,0x3B,0x50,0xFE
.db "Ori Gam ",0x26,0x39,0xED,0x08
.db "Ori Kap ",0x21,0x3D,0x67,0xF2
.db "Ori Zet ",0xE6,0x3B,0x45,0xFD
.db "Pav Alp ",0x72,0xD7,0x38,0xB0
.db "Per Alp ",0xEA,0x23,0x1E,0x46
.db "Per Bet ",0x13,0x21,0x98,0x39
.db "PsA Alp ",0x2A,0xF2,0x58,0xD6
.db "Sco Alp ",0xEB,0xAD,0xD5,0xDA
.db "Sco Lam ",0x34,0xB9,0xD3,0xCB
.db "Sco The ",0xDB,0xB9,0x89,0xC3
.db "Sgr Eps ",0x17,0xC2,0xA6,0xCF
.db "Sgr Sig ",0x8E,0xC7,0x06,0xDB
.db "Tau Alp ",0x80,0x30,0x37,0x17
.db "Tau Bet ",0x5B,0x39,0x3A,0x28
.db "TrA Alp ",0x4D,0xB1,0xEE,0x9E
.db "UMa Alp ",0xAB,0x74,0xD6,0x56
.db "UMa Eps ",0x0F,0x88,0xB1,0x4E
.db "UMa Eta ",0x77,0x91,0x58,0x45
.db "UMi Alp ",0xAF,0x1A,0x87,0x7D
.db "UMi Bet ",0x91,0x9C,0x48,0x68
.db "Vel Del ",0x3B,0x5C,0x11,0xB3
.db "Vel Gam2",0x0D,0x56,0x6F,0xBD
.db "Vir Alp ",0x89,0x8D,0x4E,0xF0


;*****************************************************************************************

fun_stars:
	rjmp	fun_stars_show1			;MNU_CALL_SHOW1
	rjmp	fun_stars_show2			;MNU_CALL_SHOW2
	rjmp	fun_stars_max_index		;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	rjmp	fun_stars_faststep		;MNU_CALL_FASTSTEP
	ret				;MNU_CALL_EXEC

fun_stars_show1:
	ldi	zl	,low(fun_stars_msg<<1)
	ldi	zh	,high(fun_stars_msg<<1)
	lds	r17	,mnu_par_index
	ldi	r18	,MNU_STAR_SIZE
	mul	r17	,r18
	add	zl	,r0
	adc	zh	,r1
	call	lcd_print_z1
	set
	ret

fun_stars_show2:
	ldi	zl	,low(fun_stars_msg<<1)
	ldi	zh	,high(fun_stars_msg<<1)
	lds	r17	,mnu_chi_index
	ldi	r18	,MNU_STAR_SIZE
	mul	r17	,r18
	add	zl	,r0
	adc	zh	,r1
	call	lcd_print_z2
	set
	ret

fun_stars_max_index:
	ldi	r16	,63
	clr	r17
	ldi	r18	,0xFF
	set
	ret

fun_stars_faststep:
	ldi	r16	,low(3)
	ldi	r17	,high(3)
	set
	ret

;*****************************************************************************************

fun_stars_align1:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_stars_align1_exec		;MNU_CALL_EXEC

fun_stars_align1_exec:
	in	r16	,SREG
	cli
	lds	r0	,mot_a_pos
	lds	r1	,mot_a_pos+1
	lds	r2	,mot_a_pos+2
	lds	r3	,mot_a_pos+3
	lds	r4	,mot_b_pos
	lds	r5	,mot_b_pos+1
	lds	r6	,mot_b_pos+2
	lds	r7	,mot_b_pos+3
	lds	r8	,clock
	lds	r9	,clock+1
	lds	r10	,clock+2
	lds	r11	,clock+3
	out	SREG	,r16

	sts	alg_az_steps1	,r0
	sts	alg_az_steps1+1	,r1
	sts	alg_az_steps1+2	,r2
	sts	alg_az_steps1+3	,r3
	sts	alg_alt_steps1	,r4
	sts	alg_alt_steps1+1	,r5
	sts	alg_alt_steps1+2	,r6
	sts	alg_alt_steps1+3	,r7
	sts	alg_time1	,r8
	sts	alg_time1+1	,r9
	sts	alg_time1+2	,r10
	sts	alg_time1+3	,r11

	ldi	zl	,low(fun_stars_msg<<1)
	ldi	zh	,high(fun_stars_msg<<1)
	lds	r17	,mnu_par_index
	ldi	r18	,MNU_STAR_SIZE
	mul	r17	,r18
	add	zl	,r0
	adc	zh	,r1
	adiw	zh:zl	,8

	lpm	r0	,Z+		;little endian
	lpm	r1	,Z+
	lpm	r2	,Z+
	lpm	r3	,Z+
	ldi	r16	,ALG_POS_NEW

	sts	alg_rectint1+1	,r0		;big endian !
	sts	alg_rectint1	,r1
	sts	alg_declint1+1	,r2
	sts	alg_declint1	,r3
	sts	alg_newpos1	,r16

	ldi	r16	,1<<TGO_ST_NONE
	sts	tgo_status	,r16

	call	mnu_out
	set
	ret

;*****************************************************************************************

fun_stars_align2:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_stars_align2_exec		;MNU_CALL_EXEC

fun_stars_align2_exec:
	in	r16	,SREG
	cli
	lds	r0	,mot_a_pos
	lds	r1	,mot_a_pos+1
	lds	r2	,mot_a_pos+2
	lds	r3	,mot_a_pos+3
	lds	r4	,mot_b_pos
	lds	r5	,mot_b_pos+1
	lds	r6	,mot_b_pos+2
	lds	r7	,mot_b_pos+3
	lds	r8	,clock
	lds	r9	,clock+1
	lds	r10	,clock+2
	lds	r11	,clock+3
	out	SREG	,r16

	sts	alg_az_steps2	,r0
	sts	alg_az_steps2+1	,r1
	sts	alg_az_steps2+2	,r2
	sts	alg_az_steps2+3	,r3
	sts	alg_alt_steps2	,r4
	sts	alg_alt_steps2+1	,r5
	sts	alg_alt_steps2+2	,r6
	sts	alg_alt_steps2+3	,r7
	sts	alg_time2	,r8
	sts	alg_time2+1	,r9
	sts	alg_time2+2	,r10
	sts	alg_time2+3	,r11

	ldi	zl	,low(fun_stars_msg<<1)
	ldi	zh	,high(fun_stars_msg<<1)
	lds	r17	,mnu_par_index
	ldi	r18	,MNU_STAR_SIZE
	mul	r17	,r18
	add	zl	,r0
	adc	zh	,r1
	adiw	zh:zl	,8

	lpm	r0	,Z+
	lpm	r1	,Z+
	lpm	r2	,Z+
	lpm	r3	,Z+
	ldi	r16	,ALG_POS_NEW

	sts	alg_rectint2+1	,r0
	sts	alg_rectint2	,r1
	sts	alg_declint2+1	,r2
	sts	alg_declint2	,r3
	sts	alg_newpos2	,r16

	ldi	r16	,TGO_ST_NONE
	sts	tgo_status	,r16

	call	mnu_out
	set
	ret

;*****************************************************************************************

fun_stars_goto:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_stars_goto_exec		;MNU_CALL_EXEC

fun_stars_goto_exec:
	ldi	zl	,low(fun_stars_msg<<1)
	ldi	zh	,high(fun_stars_msg<<1)
	lds	r17	,mnu_par_index
	ldi	r18	,MNU_STAR_SIZE
	mul	r17	,r18
	add	zl	,r0
	adc	zh	,r1
	adiw	zh:zl	,8

	lpm	r0	,Z+
	lpm	r1	,Z+
	lpm	r2	,Z+
	lpm	r3	,Z+

	sts	tgo_rectint+1	,r0
	sts	tgo_rectint	,r1
	sts	tgo_declint+1	,r2
	sts	tgo_declint	,r3

	ldi	r16	,TGO_ST_NEW_TARGET
	sts	tgo_status	,r16

	call	mnu_out
	set
	ret

;*****************************************************************************************

fun_messier:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	ret				;MNU_CALL_EXEC

;*****************************************************************************************

fun_messier_goto:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_messier_goto_exec		;MNU_CALL_EXEC

fun_messier_goto_exec:
	set
	ret


;*****************************************************************************************

fun_ngc:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	ret				;MNU_CALL_EXEC

;*****************************************************************************************

fun_ngc_goto:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_ngc_goto_exec			;MNU_CALL_EXEC

fun_ngc_goto_exec:
	set
	ret

;*****************************************************************************************

fun_radec:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_radec_exec			;MNU_CALL_EXEC

fun_radec_exec:
	clt
	lds	r16	,tgo_status
	cpi	r16	,TGO_ST_NONE
	brne	fun_radec_enter

	call	mnu_out
	set
	ret
	
fun_radec_enter:
	clt
	ret


;*****************************************************************************************

fun_radec_ra:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	ret				;MNU_CALL_EXEC

;*****************************************************************************************

fun_radec_dec:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_radec_ra_exec			;MNU_CALL_EXEC

fun_radec_ra_exec:

;*****************************************************************************************

fun_radec_setra:
	ret				;MNU_CALL_SHOW1
	rjmp	fun_radec_setra_show2		;MNU_CALL_SHOW2
	rjmp	fun_radec_setra_max_index		;MNU_CALL_MAX_IND
	rjmp	fun_radec_setra_start_index		;MNU_CALL_STARTIND
	rjmp	fun_radec_setra_faststep		;MNU_CALL_FASTSTEP
	ret				;MNU_CALL_EXEC

fun_radec_setra_show2:
	lds	AKKU_3	,mnu_chi_index
	lds	AKKU_2	,mnu_chi_index+1
	call	flt_convert_word
	f_push
	f_const	cor__rect2disp
	f_div
	f_store	tgo_rect

	lds	r16	,mnu_chi_index+1
	lds	r17	,mnu_chi_index
	ldi	xh	,high(men_message)
	ldi	xl	,low(men_message)
	call	cor_display_ra
	ldi	xh	,high(men_message)
	ldi	xl	,low(men_message)
	call	lcd_print_x2
	set
	ret

fun_radec_setra_max_index:
	ldi	r16	,low(24*60*10)		;tenth minute steps (00h - 24h)
	ldi	r17	,high(24*60*10)
	ldi	r18	,0xFF		;wrap around allowed
	set
	ret

fun_radec_setra_start_index:
	f_load	tgo_rect
	f_push
	f_const	cor__rect2disp
	f_mul
	call	flt_double2word
	mov	r16	,AKKU_3
	mov	r17	,AKKU_2
	set
	ret

fun_radec_setra_faststep:
	ldi	r16	,low(40)		;4 minutes = 1
	ldi	r17	,high(40)		;per key repeat interval (0.25 sec)
	set
	ret

;*****************************************************************************************

fun_radec_setdec:
	ret				;MNU_CALL_SHOW1
	rjmp	fun_radec_setdec_show2		;MNU_CALL_SHOW2
	rjmp	fun_radec_setdec_max_index		;MNU_CALL_MAX_IND
	rjmp	fun_radec_setdec_start_index		;MNU_CALL_STARTIND
	rjmp	fun_radec_setdec_faststep		;MNU_CALL_FASTSTEP
	ret				;MNU_CALL_EXEC

fun_radec_setdec_show2:
	lds	AKKU_3	,mnu_chi_index
	lds	AKKU_2	,mnu_chi_index+1
	ldi	r16	,low(90*60)
	sub	AKKU_3	,r16
	ldi	r16	,high(90*60)
	sbc	AKKU_2	,r16
	call	flt_convert_word
	f_push
	f_const	cor__decl2disp
	f_div
	f_store	tgo_decl

	lds	r16	,mnu_chi_index+1
	lds	r17	,mnu_chi_index
	subi	r16	,low(90*60)
	sbci	r17	,high(90*60)
	ldi	xh	,high(men_message)
	ldi	xl	,low(men_message)
	call	cor_display_dec
	ldi	xh	,high(men_message)
	ldi	xl	,low(men_message)
	call	lcd_print_x2
	set
	ret

fun_radec_setdec_max_index:
	ldi	r16	,low(180*60)		;arc minutes (-90 - +90)
	ldi	r17	,high(180*60)
	clr	r18			;no wrap around allowed
	set
	ret

fun_radec_setdec_start_index:
	f_load	tgo_decl
	f_push
	f_const	cor__decl2disp
	f_mul
	call	flt_double2word
	mov	r16	,AKKU_3
	mov	r17	,AKKU_2
	subi	r16	,low(-90*60)
	sbci	r17	,high(-90*60)
	set
	ret

fun_radec_setdec_faststep:
	ldi	r16	,low(60)		;60 arcmin = 1
	ldi	r17	,high(60)		;per key repeat interval (0.25 sec)
	set
	ret

;*****************************************************************************************

fun_profiles_msg:
	.db " * of 4 "
fun_profiles:
	rjmp	fun_profiles_show1		;MNU_CALL_SHOW1
	rjmp	fun_profiles_show2		;MNU_CALL_SHOW2
	rjmp	fun_profiles_max_index		;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	ret				;MNU_CALL_EXEC

fun_profiles_show1:
	ldi	zl	,low(fun_profiles_msg<<1)
	ldi	zh	,high(fun_profiles_msg<<1)
	call	lcd_print_z1
	lds	r17	,mnu_par_index
	ldi	r16	,'1'
	add	r16	,r17
	sts	lcd_line_1+7	,r16
	set
	ret

fun_profiles_show2:
	ldi	zl	,low(fun_profiles_msg<<1)
	ldi	zh	,high(fun_profiles_msg<<1)
	call	lcd_print_z2
	lds	r17	,mnu_chi_index
	ldi	r16	,'1'
	add	r16	,r17
	sts	lcd_line_2+1	,r16
	set
	ret

fun_profiles_max_index:
	ldi	r16	,3
	clr	r17
	set
	ret

;*****************************************************************************************

fun_profile_act:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_profile_act_exec		;MNU_CALL_EXEC

fun_profile_act_exec:
	lds	r16	,mnu_par_index
	call	eep_load_profile
	call	mnu_out
	set
	ret

;*****************************************************************************************

fun_prof_makedef:
	ret				;MNU_CALL_SHOW1
	ret				;MNU_CALL_SHOW2
	ret				;MNU_CALL_MAX_IND
	ret				;MNU_CALL_STARTIND
	ret				;MNU_CALL_FASTSTEP
	rjmp	fun_prof_makedef_exec		;MNU_CALL_EXEC

fun_prof_makedef_exec:
	lds	r16	,mnu_par_index
	ldi	zh	,high(eep_prof_default)
	ldi	zl	,low(eep_prof_default)
	call	eep_write
	call	mnu_out
	set
	ret

;*****************************************************************************************
