;************************************************************
;IEEE 64 Bit Floating Point Library       (c) 2003 M.Cibulski
;
;Include File
;(Formatted for editor tab witdth of 18 characters)
;
;************************************************************
;Register Definitions

;************************************************************
;Offsets to Y after CALL, PUSH YL, PUSH YH

.EQU	FLT_Y_S		=  5
.EQU	FLT_Y_E1		=  6
.EQU	FLT_Y_E2		=  7
.EQU	FLT_Y_2		=  8
.EQU	FLT_Y_3		=  9
.EQU	FLT_Y_4		= 10
.EQU	FLT_Y_5		= 11
.EQU	FLT_Y_6		= 12
.EQU	FLT_Y_7		= 13
.EQU	FLT_Y_8		= 14


;************************************************************
;AKKU registers

.DEF	AKKU_E2		= r2
.DEF	AKKU_E1		= r3
.DEF	AKKU_S		= r4
.DEF	AKKU_2		= r5
.DEF	AKKU_3		= r6
.DEF	AKKU_4		= r7
.DEF	AKKU_5		= r8
.DEF	AKKU_6		= r9
.DEF	AKKU_7		= r10
.DEF	AKKU_8		= r11

.DEF	AKKUB_2		= r12
.DEF	AKKUB_3		= r13
.DEF	AKKUB_4		= r14
.DEF	AKKUB_5		= r15
.DEF	AKKUB_6		= r18
.DEF	AKKUB_7		= r19
.DEF	AKKUB_8		= r20

;************************************************************

.equ	FLT_E_NAN	= 0x7FF
.equ	FLT_E_BIAS	= 0x3FF
.equ	FLT_SIZE	= 8

.DSEG
_flt_debug:	.BYTE	8

.INCLUDE	"float_constants.asm"
.INCLUDE	"float_macros.asm"
.INCLUDE	"float_intern.asm"
.INCLUDE	"float_convert.asm"
.INCLUDE	"float_text_io.asm"
.INCLUDE	"float_binop.asm"
.INCLUDE	"float_matrix.asm"
.INCLUDE	"float_compare.asm"
.INCLUDE	"float_transfer.asm"
.INCLUDE	"float_sqrt.asm"
.INCLUDE	"float_powerseries.asm"
.INCLUDE	"float_atan.asm"
.INCLUDE	"float_sincos.asm"
.INCLUDE	"float_test.asm"

;************************************************************
