
;************************************************************
;IEEE 64 Bit Floating Point Library       (c) 2003 M.Cibulski
;
;Format Manipulations
;
;************************************************************


;****************************************************************************************
;Add Value to Exponent (fast multiply/divide by powers of 2)
;
;r17:r16	Added Value
;
;Registers:
;AKKU	floating point akkumulator
;
;****************************************************************************************

.CSEG
flt_addexp:
	mov	r18	,AKKU_E1		;check if zero
	or	r18	,AKKU_E2
	breq	flt_adx_end			;yes, return zero

	ldi	r18	,low(0x7FF)		;exponent of NAN
	ldi	r19	,high(0x7FF)
	cp	AKKU_E2	,r18		;check if NAN
	cpc	AKKU_E1	,r19
	breq	flt_adx_end			;yes, return NAN

	add	AKKU_E2	,r16		;add number to exponent
	adc	AKKU_E1	,r17

	tst	r17			;negative number added ?
	brmi	flt_adx_negative			;yes, check underflow (= zero result)

	cp	AKKU_E2	,r18		;exponent too high (>= 0x7FF) ?
	cpc	AKKU_E1	,r19
	brcs	flt_adx_end			;no, return result

	movw	AKKU_E1:AKKU_E2	,r19:r18		;return NAN
	clr	AKKU_S
	clr	AKKU_2
	clr	AKKU_3
	clr	AKKU_4
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8
	ret

flt_adx_negative:
	tst	AKKU_E1			;underflow in exponent ?
	brmi	flt_adx_zero			;yes, return zero

	brne	flt_adx_end			;not zero, return result

	tst	AKKU_E2
	brne	flt_adx_end			;not zero, return result

flt_adx_zero:
	clr	AKKU_E1			;return zero
	clr	AKKU_E2
	clr	AKKU_S
	clr	AKKU_2
	clr	AKKU_3
	clr	AKKU_4
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8

flt_adx_end:
	ret


;************************************************************
;Integer Part of Akku A
;
;Parameters:
;Akku A	X
;
;Registers:
;AKKU	floating point akkumulator
;
;************************************************************

.CSEG
flt_floor_mask:
	.DB	0x00,0x80,0xc0,0xe0,0xf0,0xf8,0xfc,0xfe

flt_floor:
	push	zl
	push	zh

	;call	flt_check_nan_a		;x=NAN ?
	;brtc	flt_floor_01
	;rjmp	flt_floor_end		;   return NAN

flt_floor_01:
	;call	flt_check_zero_a		;x=0 ?
	;brtc	flt_floor_02
	;rjmp	flt_floor_end		;   return 0

flt_floor_02:
	ldi	r17	,0x03	;remove bias from exponent
	ldi	r16	,0xff
	sub	AKKU_E2	,r16
	sbc	AKKU_E1	,r17

	tst	AKKU_E1		;negative exponent ?
	brpl	flt_floor_gt1		;no, abs(x) >= 1.0

	tst	AKKU_S		;negative x
	brpl	flt_floor_03		;no, 0.0 < x < 1.0, return 0.0

	f_const	flt__minus1		;yes, -1.0 < x < 0.0, return -1.0
	rjmp	flt_floor_end

flt_floor_03:
	f_zero
flt_floor_toend:
	rjmp	flt_floor_end
	
flt_floor_gt1:
	tst	AKKU_E1
	brne	flt_floor_toend

	mov	r16	,AKKU_E2
	cpi	r16	,52
	brcc	flt_floor_toend

	subi	r16	,4
	andi	r16	,0x7
	clr	r17	
	ldi	zl	,low(flt_floor_mask<<1)
	ldi	zh	,high(flt_floor_mask<<1)
	add	zl	,r16
	adc	zh	,r17
	lpm	r0	,Z
	mov	r1	,r0
	com	r1

	mov	r16	,AKKU_E2
	cpi	r16	,44
	brcs	flt_floor_below44

	mov	r16	,AKKU_8
	eor	r16	,r0
	and	AKKU_8	,r0
	rjmp	flt_floor_04

flt_floor_below44:
	cpi	r16	,36
	brcs	flt_floor_below36

	and	r1	,AKKU_7
	or	r1	,AKKU_8
	and	AKKU_7	,r0
	clr	AKKU_8
	rjmp	flt_floor_04

flt_floor_below36:
	cpi	r16	,28
	brcs	flt_floor_below28

	and	r1	,AKKU_6
	or	r1	,AKKU_7
	or	r1	,AKKU_8
	and	AKKU_6	,r0
	clr	AKKU_7
	clr	AKKU_8
	rjmp	flt_floor_04

flt_floor_below28:
	cpi	r16	,20
	brcs	flt_floor_below20

	and	r1	,AKKU_5
	or	r1	,AKKU_6
	or	r1	,AKKU_7
	or	r1	,AKKU_8
	and	AKKU_5	,r0
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8
	rjmp	flt_floor_04

flt_floor_below20:
	cpi	r16	,12
	brcs	flt_floor_below12

	and	r1	,AKKU_4
	or	r1	,AKKU_5
	or	r1	,AKKU_6
	or	r1	,AKKU_7
	or	r1	,AKKU_8
	and	AKKU_4	,r0
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8
	rjmp	flt_floor_04

flt_floor_below12:
	cpi	r16	,4
	brcs	flt_floor_below4

	and	r1	,AKKU_3
	or	r1	,AKKU_4
	or	r1	,AKKU_5
	or	r1	,AKKU_6
	or	r1	,AKKU_7
	or	r1	,AKKU_8
	and	AKKU_3	,r0
	clr	AKKU_4
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8
	rjmp	flt_floor_04

flt_floor_below4:
	and	r1	,AKKU_2
	or	r1	,AKKU_3
	or	r1	,AKKU_4
	or	r1	,AKKU_5
	or	r1	,AKKU_6
	or	r1	,AKKU_7
	or	r1	,AKKU_8
	and	AKKU_2	,r0
	clr	AKKU_3
	clr	AKKU_4
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8

flt_floor_04:
	ldi	r16	,0x03	;add bias 0x3FF to exponent
	ldi	r17	,0xff
	add	AKKU_E2	,r17
	adc	AKKU_E1	,r16

	tst	r1		;any bits masked ?
	breq	flt_floor_end		;no
	
	tst	AKKU_S		;negative number ?
	brpl	flt_floor_end		;no
	
	f_push			;x -= 1.0
	f_const	flt__1
	f_sub

flt_floor_end:
	pop	zh
	pop	zl
	ret


;************************************************************
