
;************************************************************
;IEEE 64 Bit Floating Point Library       (c) 2003 M.Cibulski
;
;Macros
;
;************************************************************

.DSEG
_debuga:	.BYTE	8

.CSEG
flt_debug:
	ret

.MACRO	f_debug
	ldi	xl	,low(_debuga)
	ldi	xh	,high(_debuga)
	call	flt_store_x
	call	flt_debug
.ENDMACRO

;************************************************************



.MACRO	local
	push	yl
	push	yh
	in	yl	,spl
	in	yh	,sph
	subi	yl	,low(@0)
	sbci	yh	,high(@0)
	;sbiw	yh:yl	,@0
	cli
	out	spl	,yl
	out	sph	,yh
	sei
.ENDMACRO
			
.MACRO	endlocal
	subi	yl	,low(-@0)
	sbci	yh	,high(-@0)
	;adiw	yh:yl	,@0
	cli
	out	spl	,yl
	out	sph	,yh
	sei
	pop	yh
	pop	yl
.ENDMACRO


;************************************************************

.MACRO	f_chs
	ldi	@0	,0x80
	eor	AKKU_S	,@0
.ENDMACRO

.MACRO	f_abs
	clr	AKKU_S
.ENDMACRO

.MACRO	f_ldiexp
	ldi	@0	,low(@1)
	mov	AKKU_E2	,@0
	ldi	@0	,high(@1)
	mov	AKKU_E1	,@0
.ENDMACRO

.MACRO	f_subexp
	ldi	r16	,low(-@0)
	ldi	r17	,high(-@0)
	call	flt_addexp
.ENDMACRO

.MACRO	f_addexp
	ldi	r16	,low(@0)
	ldi	r17	,high(@0)
	call	flt_addexp
.ENDMACRO

.MACRO	f_isnumber
	ldi	@0	,0x07
	cp	AKKU_E1	,@0
	brne	@1

	ldi	@0	,0xFF
	cp	AKKU_E2	,@0
	brne	@1
.ENDMACRO

;************************************************************

.MACRO	f_x_gt_0
	call	flt_x_gt_0
.ENDMACRO

.MACRO	f_x_lt_0
	call	flt_x_lt_0
.ENDMACRO

.MACRO	f_x_ge_0
	call	flt_x_ge_0
.ENDMACRO

.MACRO	f_x_le_0
	call	flt_x_le_0
.ENDMACRO

.MACRO	f_x_eq_0
	call	flt_x_eq_0
.ENDMACRO

.MACRO	f_x_ne_0
	call	flt_x_ne_0
.ENDMACRO

;************************************************************

.MACRO	f_x_eq_y
	call	flt_x_eq_y
.ENDMACRO


.MACRO	f_x_gt_y
	call	flt_x_gt_y
.ENDMACRO

.MACRO	f_y_lt_x
	call	flt_x_gt_y
.ENDMACRO


.MACRO	f_x_le_y
	call	flt_x_le_y
.ENDMACRO

.MACRO	f_y_ge_x
	call	flt_x_le_y
.ENDMACRO


.MACRO	f_x_ge_y
	call	flt_x_ge_y
.ENDMACRO

.MACRO	f_y_le_x
	call	flt_x_ge_y
.ENDMACRO


.MACRO	f_x_lt_y
	call	flt_x_lt_y
.ENDMACRO

.MACRO	f_y_gt_x
	call	flt_x_lt_y
.ENDMACRO

;************************************************************
.MACRO	f_add
	call	flt_add
.ENDMACRO

.MACRO	f_sub
	call	flt_sub
.ENDMACRO

.MACRO	f_mul
	call	flt_mul
.ENDMACRO

.MACRO	f_div
	call	flt_div
.ENDMACRO

;************************************************************

.MACRO	f_zero
	call	flt_zero
.ENDMACRO

.MACRO	f_const
	ldi	zl	,low(@0 << 1)
	ldi	zh	,high(@0 << 1)
	call	flt_load_z
.ENDMACRO


.MACRO	f_load
	ldi	xl	,low(@0)
	ldi	xh	,high(@0)
	call	flt_load_x
.ENDMACRO

.MACRO	f_load_l
	mov	xl	,yl
	mov	xh	,yh
	subi	xl	,low(-@0)
	sbci	xh	,high(-@0)
	call	flt_load_x
.ENDMACRO

.MACRO	f_store
	ldi	xl	,low(@0)
	ldi	xh	,high(@0)
	call	flt_store_x
.ENDMACRO

.MACRO	f_store_l
	mov	xl	,yl
	mov	xh	,yh
	subi	xl	,low(-@0)
	sbci	xh	,high(-@0)
	call	flt_store_x
.ENDMACRO

.MACRO	f_push
	call	flt_push
.ENDMACRO

.MACRO	f_pop
	call	flt_pop
.ENDMACRO

.MACRO	f_xy
	call	flt_xy
.ENDMACRO

.MACRO	f_load_array
	ldd	xh	,Y+@0
	ldd	xl	,Y+@0+1
	adiw	xh:xl	,8*@1
	call	flt_load_x
.ENDMACRO

.MACRO	f_store_array
	ldd	xh	,Y+@0
	ldd	xl	,Y+@0+1
	adiw	xh:xl	,8*@1
	call	flt_store_x
.ENDMACRO

;************************************************************
.MACRO	f_floor
	call	flt_floor
.ENDMACRO

.MACRO	f_sin
	call	flt_sin
.ENDMACRO

.MACRO	f_cos
	call	flt_cos
.ENDMACRO

.MACRO	f_atan
	call	flt_atan
.ENDMACRO

.MACRO	f_atan2
	call	flt_atan2
.ENDMACRO

.MACRO	f_sqrt
	call	flt_sqrt
.ENDMACRO

.MACRO	f_powerseries
	ldi	zl	,low (@0<<1)
	ldi	zh	,high (@0<<1)
	call	flt_powerseries
.ENDMACRO


;************************************************************
